#! /usr/bin/python

# file patterns
ptn_jpeg = {'pattern' : "*.jpg"}
ptn_mpeg = {'pattern' : "*.mpeg"}
ptn_mp3  = {'pattern' : "*.mp3"}
ptn_any  = {'pattern' : None}

# default directories
demo  = "/usr/share/ads/demo_media/"
image = "/etc/X11/adslauncher/images/"

# icon image files
ico_jpeg  = {'icon' : None, 'image' : image + "image32.gif"}
ico_mpeg  = {'icon' : None, 'image' : image + "movie32.gif"}
ico_mp3   = {'icon' : None, 'image' : image + "music32.gif"}
ico_scope = {'icon' : None, 'image' : image + "ping32.gif"}
ico_dillo = {'icon' : None, 'image' : image + "dillo32.gif"}
ico_xterm = {'icon' : None, 'image' : image + "xterm32.gif"}
ico_voip  = {'icon' : None, 'image' : image + "voip.gif"}
ico_gps   = {'icon' : None, 'image' : image + "gps.gif"}
ico_speed = {'icon' : None, 'image' : image + "chip32.gif"}
ico_sleep = {'icon' : None, 'image' : image + "sleep32.gif"}
ico_boot  = {'icon' : None, 'image' : image + "restart32.gif"}
ico_info  = {'icon' : None, 'image' : image + "info32.gif"}
ico_yes   = {'icon' : None, 'image' : image + "yes32.gif"}
ico_no    = {'icon' : None, 'image' : image + "no32.gif"}
ico_cam   = {'icon' : None, 'image' : image + "xawtv.gif" }

# cpu frequencies
#pxa27x = { '104 MHz' : 104000, '208 MHz' : 208000, '312 MHz' : 312000,
#           '416 MHz' : 416000, '520 MHz' : 520000 } # , '624 MHz' : 624000 }
#pxa25x = { '99 MHz'  :  99000, '199 MHz' : 200000,
#           '298 MHz' : 300000, '398 MHz' : 399000 }
#freqs = pxa25x

# menu items
#
# each menu item is a dictionary (i.e, 'key' : 'value' pairs)
# a button will be created for each menu item in the menu array(s)
# appropriate action will take place when the button is pressed
#
# keys:
#   label   - text for the menu item's button
#   color   - color of the label text
#   msg     - message for the status window (NOT USED - status removed)
#   cmd     - command to invoke when the button is pressed
#   arg     - text to display when requesting additional user input
#   choices - dictionary containing choices for user selection
#   default - default argument value or message to print
#
# rules:
#   all items must have label and msg values (the msg can be "")
#   the color and default values are optional
#   the remaining values control the items operation:
#
#   to do this                                 an item must
#   ----------                                 ------------
#   execute a simple non-interactive command - have cmd but no arg
#   execute command with user supplied input - have cmd and arg, but no choices
#   execute command with user selection      - have cmd, arg, and multiple choices
#   execute command with user selected file  - have cmd, arg, and single choice 
#
jpeg  = {'label' : "View JPEG", 'msg' : "View JPEG image", 'icon' : ico_jpeg,
         'cmd' : "xloadimage -title 'JPEG Viewer'",
         'arg' : "Enter JPEG file", 'choices' : ptn_jpeg, 'default' : demo}

# Note that the X and Y resolution should exactly match the video for best
# effects. In particular, some accelleration cannot perfom scaling, which
# will result in a black screen if the numbers do not match the video
# resolution.
mpeg  = {'label' : "Play MPEG", 'msg' : "Play MPEG video", 'icon' : ico_mpeg,
         'cmd' : "ffplay -x 352 -y 240",
         'arg' : "Enter MPEG file", 'choices' : ptn_mpeg, 'default' : demo}

play  = {'label' : "Play MP3", 'msg' : "Play MP3 audio", 'icon' : ico_mp3,
         'cmd' : "xterm -geometry 50x10+200+30 -T 'madplay' -e madplay",
         'arg' : "Enter mp3 file", 'choices' : ptn_mp3, 'default' : demo}

dillo = {'label' : "Browser", 'msg' : "Browse web pages", 'icon' : ico_dillo,
         'cmd' : "dillo -g 400x300+200+130 http://www.applieddata.net/ &> /dev/null"}

camera = {'label' : "Web-cam", 'msg' : "Display web-cam", 'icon' : ico_cam,
	 'cmd' : "xawtv &>/dev/null"}

xterm = {'label' : "Terminal", 'msg' : "Command prompt", 'icon' : ico_xterm,
        'cmd' : "xterm -ls"}

#speed = {'label' : "CPU Speed", 'msg' : "Set CPU frequency", 'icon' : ico_speed,
#        'cmd' : "setspeed",
#        'arg' : "Select CPU Frequency",
#	'choices' : freqs}
speed = {'label' : "CPU Speed", 'msg' : "Set CPU frequency", 'icon' : ico_speed,
	 'cmd' : "/etc/X11/adslauncher/speedswitch.sh" }

sleep = {'label' : "Sleep", 'msg' : "Suspend the system", 'icon' : ico_sleep,
         'cmd' : "/usr/local/sbin/gosleep",
         'arg' : "Enter time in seconds, 0=no timeout",
	 'default' : 10}

boot  = {'label' : "Shutdown", 'msg' : "Shutdown/Reboot", 'icon' : ico_boot,
	'cmd' : "/etc/X11/adslauncher/shutdown.sh",
	'color' : "red" }

about = {'label' : "About", 'msg' : "This is the ADS Python-Tk demo menu",
	 'icon' : ico_info,
	 'default' : "Applied Data Systems' Python-Tk demo menu"}

gps   = {'label' : "GPS", 'msg' : "GPS Client", 'icon' : ico_gps,
	 'cmd' : '/etc/X11/adslauncher/gps.sh' }

voip  = {'label' : "VoIP", 'msg' : "Voice-over-IP", 'icon' : ico_voip,
	 'cmd' : "/etc/X11/adslauncher/voipdemo.py" }

# menu(s)
l_menu = [ jpeg,  mpeg,  play, camera, dillo, xterm, gps, voip]
 
m_menu =  [speed, sleep]

s_menu = [boot]


DEFAULT_FONT_FAMILY = ("MS", "Sans", "Serif")
DEFAULT_FONT_SIZE   = 10
DEFAULT_FONT        = (DEFAULT_FONT_FAMILY, DEFAULT_FONT_SIZE)

BTN_FONT  = ("helvetica", 14, 'bold')
BTN_WIDTH = 14

from Tkinter import *
from curry import *
from entry import *
from choice import *
#import base64
import sys
import os

class App:
    """ adsmenu, a python/tk menu application
    creates a little menu program to launch demo applications
    Originally written by Jeff Lackey <jlackey@applieddata.net>
    Modified by Josh Malone <jmalone@applieddata.net> for the
    evaluation system root filesystems.

    Applied Data Systems, http://www.applieddata.net/
    """

    def __init__(self, parent):

        frame = Frame(parent)
        frame.pack(ipadx="1m", padx="1m", pady=3)

        # top frame - for padding
        top = Frame(frame, height=5)
        top.pack(side=TOP, fill=X, expand=YES)

        # middle frame - for buttons
        mid = Frame(frame, height=5)
        mid.pack(side=TOP, fill=X, expand=YES)

        # left frame - first column of buttons
        left = Frame(mid)
        left.pack(side=LEFT, fill=Y, expand=YES)
            
        for item in l_menu:
            self.btn = self.add_menu_item(left, item)

        myproc = os.popen("grep -i 'sphere\|portal' /proc/cpuinfo", "r")
        hw_string = myproc.read()
        if len(hw_string) == 0:
        	for item in m_menu:
        	    self.btn = self.add_menu_item(left, item)
 
        for item in s_menu:
            self.btn = self.add_menu_item(left, item)

        # bottom frame - for padding
        bottom = Frame(frame, height=10)
        bottom.pack(side=TOP, fill=X, expand=YES)


    def add_menu_item(self, frame, item):
        """Determine the item type and add it to the menu"""
        label = item['label']
        if item.get('cmd', None):
            if item.get('arg', None):
                if item.get('choices', None):
                    if len(item['choices']) > 1:
                        btn = menu_btn(frame, label, BTN_WIDTH, self.exec_pick_item, item)
                    else:
                        btn = menu_btn(frame, label, BTN_WIDTH, self.exec_file_item, item)
                else:
                    btn = menu_btn(frame, label, BTN_WIDTH, self.exec_user_item, item)
            else:
                btn = menu_btn(frame, label, BTN_WIDTH, self.exec_cmd, item)
        else:
            btn = menu_btn(frame, label, BTN_WIDTH, self.print_msg, item)
        if item.get('color', None):
            btn.configure(fg=item['color'])
        return btn

    def print_msg(self, item):
        if item.get('default', None):
            print item['default']

    def exec_cmd(self, item):
        os.system(item['cmd'] + " &")

    def exec_user_item(self, item):
        entry = enterbox(item['arg'], item['label'], item.get('default', None))
        if entry:
            os.system(item['cmd'] + " " + entry + " &")

    def exec_file_item(self, item):
        pattern = item['choices']['pattern']
        file = fileopenbox(item['arg'], item['label'],
                           default=item.get('default', None), pattern=pattern)
        if file:
            os.system(item['cmd'] + ' "' + file + '" &')

    def exec_pick_item(self, item):
        choice = choicebox(item['arg'], item['label'], item['choices'])
        if choice:
            os.system(item['cmd'] + " " + str(item['choices'][choice]) + " &")


def icon_btn(frame, func, item):
    """Make an icon button and bind a function to it"""
    icon = PhotoImage(file=item['icon']['image'])
    btn = Button(frame, command=curry(func, item))
    btn.bind("<Return>", event_lambda(func, item))
    btn.configure(image=icon)
    btn.pack(side=LEFT)
    item['icon']['icon']  = icon
    return btn

def text_btn(frame, label, width, func, item):
    """Make a text button and bind a function to it"""
    btn = Button(frame, command=curry(func, item))
    btn.bind("<Return>", event_lambda(func, item))
    btn.configure(text=label, font=BTN_FONT, width=width)
    btn.pack(side=RIGHT, fill=Y)
    return btn

def menu_btn(frame, label, width, func, item):
    """Make a button for an item and bind a function to it"""
    if item.get('icon', None):
        combo = Frame(frame)
        combo.pack(side=TOP, fill=Y, expand=YES)
        btn = text_btn(combo, label, width-4, func, item)
        icon_btn(combo, func, item)
    else:
        btn = Button(frame, command=curry(func, item))
        btn.bind("<Return>", event_lambda(func, item))
        btn.configure(text=label, font=BTN_FONT, width=width)
        btn.pack(side=TOP)
    return btn

root = Tk()
root.wm_title("ADS Launcher")
root.wm_geometry("+0+10")
app = App(root)
root.mainloop()
