#!/bin/bash

OFFSET="+200+50"
GEOMETRY="-geometry x55${OFFSET}"

askdevice () {

	port=$(xmessage ${GEOMETRY} -print -buttons "ttyS0,ttyS1,ttyS2,ttyAM0,ttyAM1,Cancel:2" \
	"To which port is your GPS connected?" )

	case $? in

	    1)
	    	# Prompt for text input
		# Unimplemented
		exit 1
		;;
		
	    2)
	    	exit 2
		;;
	esac

	GPSPORT="/dev/${port}"
}

GPSPIDFILE=/var/run/gpsd.pid

startgps () {
	killall gpsd &> /dev/null
	gpsd -p "$1" -P "${GPSPIDFILE}" -n &> /dev/null
}

stopgps () {
	if [ -f "${GPSPIDFILE}" ]; then
		kill $(cat ${GPSPIDFILE}) &> /dev/null
	fi
}

#############################################################

askdevice
if [ -z "${GPSPORT}" ]; then
	echo "Unable to determin GPS port!"
	exit 1
else
	echo "Starting gpsd on ${GPSPORT}"
	startgps "${GPSPORT}"
	sleep 2		# give gpsd time to aquire 3 satellites
fi

output=$(gpsclient)

retcode=$?

coords=$(echo "${output}" | tail -1)

if [ ${retcode} != 0 ]; then
	bstring='Dismiss:4'
else
	bstring='Display Map:3,Dismiss:4'
fi
	
	
xmessage ${GEOMETRY} -buttons "${bstring}" "${coords}"

case $? in

	2)
	    coords=$(gpsclient | tail -1)
	    xmessage ${GEOMETRY} "${coords}"
	    ;;

	3)
	    gpsclient -m
	    ;;
esac

stopgps
