#!/usr/bin/python

from Tkinter import *
import sys

def ipbox(message="Enter IP Address", title="IP Entry"):


	global root, __enterText, cancelButton, entryWidget, okayButton
	global numEntered
	if title == None: title = ""
	if message == None: message = ""

	numEntered=0

	root = Tk()
	root.title(title)
	root.wm_title(title)
	root.wm_geometry("+200+120")

	topFrame = Frame(root)
	topFrame.pack(side=TOP, fill=BOTH, expand=YES)

	numFrame = Frame(root)
	numFrame.pack(fill=BOTH, side=TOP, expand=YES)

	buttonFrame = Frame(root)


	entryWidget = Entry(topFrame, width=20)
	entryWidget.pack(side=LEFT, expand=YES)
	entryWidget.insert(0, message)

	# Assemble number pad in numframe

	b1 = Button(numFrame, text="1", command=lambda: ipInsert('1') )
	b2 = Button(numFrame, text="2", command=lambda: ipInsert('2') )
	b3 = Button(numFrame, text="3", command=lambda: ipInsert('3') )
	b4 = Button(numFrame, text="4", command=lambda: ipInsert('4') )
	b5 = Button(numFrame, text="5", command=lambda: ipInsert('5') )
	b6 = Button(numFrame, text="6", command=lambda: ipInsert('6') )
	b7 = Button(numFrame, text="7", command=lambda: ipInsert('7') )
	b8 = Button(numFrame, text="8", command=lambda: ipInsert('8') )
	b9 = Button(numFrame, text="9", command=lambda: ipInsert('9') )
	b0 = Button(numFrame, text="0", command=lambda: ipInsert('0') )
	bdot = Button(numFrame, text=".", command=lambda: ipInsert('.') )
	bback = Button(numFrame, text="Bksp", command=lambda: ipBksp() )

	b1.grid(row=0, column=0, ipadx=15, ipady=15)
	b2.grid(row=0, column=1, ipadx=15, ipady=15)
	b3.grid(row=0, column=2, ipadx=15, ipady=15)
	b4.grid(row=1, column=0, ipadx=15, ipady=15)
	b5.grid(row=1, column=1, ipadx=15, ipady=15)
	b6.grid(row=1, column=2, ipadx=15, ipady=15)
	b7.grid(row=2, column=0, ipadx=15, ipady=15)
	b8.grid(row=2, column=1, ipadx=15, ipady=15)
	b9.grid(row=2, column=2, ipadx=15, ipady=15)
	b0.grid(row=3, column=1, ipadx=15, ipady=15)
	bback.grid(row=3, column=0, ipadx=10, ipady=15)
	bdot.grid(row=3, column=2, ipadx=15, ipady=15)

	# Put OK/Cancel buttons on bottom

	okayButton = Button(buttonFrame, text="Okay")
	okayButton.pack(side=LEFT, expand=YES, ipadx=5, ipady=10)
	okayButton.bind("<Button-1>", __boxOkay)

	cancelButton = Button(buttonFrame, text="Cancel")
	cancelButton.pack(side=RIGHT, expand=YES, ipadx=5, ipady=10)
	cancelButton.bind("<Button-1>", __boxCancel)

	buttonFrame.pack(side=BOTTOM, fill=BOTH, expand=YES, pady="3m")


	entryWidget.focus_force()
	root.mainloop()
	root.destroy()
	return __enterText

def __boxOkay(event):
    	global root, __enterText, entryWidget
	__enterText = entryWidget.get()
	root.quit()

def __boxCancel(event):
    	global root, __enterText
	__enterText = ""
	root.quit()

def ipInsert(iText):
	global entryWidget, numEntered
	entryWidget.insert(END, iText)


def ipBksp():
	global entryWidget, numEntered
	foo = entryWidget.get()
	tLast = len(foo) - 1
	entryWidget.delete(tLast)


theIP = ipbox(sys.argv[1], title="Enter IP Address")
if theIP:
	print theIP
	sys.exit(0)
else:
	sys.exit(1)
