#!/bin/bash

PREFIX=/etc/X11/adslauncher

if ! [ -z "$1" ]; then
	if [ "$1" = '-l' ]; then
		localaddr="$2"
		shift
		shift
		xmessage -geometry x55+200+30 "My IP address is $localaddr" &
		IPwin=$!
	fi
fi

if ! [ -z "$1" ]; then
	IP="$1"
else
	if [ -z "${localaddr}" ]; then
	    IP=$(${PREFIX}/ipbox.py)
	else
	    IP=$(${PREFIX}/ipbox.py ${localaddr%.*}.)
	fi
	if [ -z "$IP" ]; then
		if ! [ -z "${IPwin}" ]; then
			kill ${IPwin} 2>&1 >/dev/null
		fi
		exit 1
	fi
fi


sfspeaker &
speakerPID=$!

sfmike -A "$IP" &
micPID=$!

xmessage -geometry x55+200+30 -buttons "Disconnect:2" "Running Speak Freely to $IP"

kill "${micPID}"
kill "${speakerPID}"

if ! [ -z "${IPwin}" ]; then
	kill ${IPwin} 2>&1 >/dev/null
fi
