#!/bin/bash

notsupported () {
	xmessage -geometry x55 "This system type ($1) does not support speed scaling"
	exit 1
}

systemtype=$(cat /proc/cpuinfo | grep Processor | sed -e 's/.*: //')

case ${systemtype} in

    *PXA27*)
    	speeds='104 MHz,208 MHz,312 MHz,416 MHz,520 MHz'
    	;;

    *PXA25*)
    	speeds='99 MHz,199 MHz,299 MHz,399 MHz'
	;;

    *)
	notsupported "${systemtype}"
    	;;
esac

selection=$(xmessage -geometry x55 -print -buttons "${speeds}" "Select CPU speed")

if [ -z "${selection}" ]; then
	exit
fi

# Note 999 is a fuzz factor because some boards only change freq at 199100
# not 199000.
speed="${selection% MHz}999"

exec setspeed "${speed}"
