#!/usr/bin/python

from Tkinter import *

import sys
import os
import string

def genaddr ():
	"""Generate a self-assigned address (link-local addressing)
	based on a persistent identifier (eth0 MAC address)"""
	
	LLAprefix = '169.254.138'
	seedIF = 'eth0'

	myproc = os.popen("ifconfig %s | grep HWaddr" % seedIF, "r" )
	seedstring = myproc.read()
	myproc.close()
	if len(seedstring) > 0:

	    myproc = os.popen("echo -n '%s' | sed -e 's/.*HWaddr //' -e 's/://g'" % seedstring, "r")
	    seedstring = myproc.read()
	    myproc.close()
	    octfour = (( int( seedstring,16) /2 ) % 253) + 1
	    myaddr = LLAprefix + ".%d" % (octfour)

	    return myaddr

	else:

	    # No seed
	    myaddr = LLAprefix + '.67'
	    return myaddr
	

netdevs = [ 'eth0' ]
networked = 0

for item in netdevs:
	print "Checking",item
	myproc = os.popen("ifconfig | grep '%s'" % item, "r")
	lines = myproc.readlines()
	myproc.close()
	
	if len(lines) > 0:
	    networked = 1
	    myproc = os.popen("ifconfig %s | grep 'inet addr' | sed -e 's/.*inet addr://' -e 's/ .*//'" % item, "r")
	    rataddr = myproc.read()
	    myproc.close()
	    rataddr = string.rstrip(rataddr, '\n')
	    break


if networked == 1:
	print "Network OK"

else:
	print "No IP address - performing self-assignment"

	saaddr = genaddr()
	rataddr = saaddr

	print "Assigning address", saaddr
	os.system("ifconfig %s %s netmask 0xffff0000" %(item,saaddr) )

os.system("/etc/X11/adslauncher/speakfreely.sh -l %s &" %rataddr)
