#! /bin/sh
#
# /etc/X11/xcalibrate/xcalibrate.sh
#
# This script is run to calibrate the touchscreen
# Run this script with '-r' option to recalibrate the screen

CONF=/etc/X11/xcalibrate/xcalibrate.conf
DRIVER26=/sys/bus/platform/drivers/ads784x/ads784x
DISPLAY=${DISPLAY:-\:0}
export DISPLAY

# Kernel environment variable that can be used to turn off calibraration.
if [ "$NOCALIBRATE" = 1 ]; then
	exit 0
fi

# If no touchscreen driver - don't calibrate the screen
#if grep -q '11.*ts' /proc/devices || [ -L "${DRIVER26}" ]
if echo -n < /dev/ts_raw
then

# Find out if screen saver is enabled
xstat=$(xset q 2>/dev/null | grep 'timeout:')
match=$(expr match '$xstat' ' *timeout: *0.*')

xset s off
if [ ! -e ${CONF} ] || [ ! -s ${CONF} ] || [ "$1" == '-r' ]; then
	xcalibrate < /dev/null >& /dev/null
	xcalibrate -view < /dev/null > ${CONF}
else
	xcalibrate -cal $(cat ${CONF}) < /dev/null >& /dev/null
fi

if ! [ $match -eq 0 ]; then
	# SS was on before we turned it off
	xset s on
	xset s 60 5
	xset s noblank
fi

fi	# Driver detection
