#!/bin/sh

XINITRC=/etc/X11/xinit/xinitrc-ads2
PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/X11R6/bin:/usr/local/sbin:/usr/local/bin
TSLIB_PLUGINDIR=/usr/lib/ts
export TSLIB_PLUGINDIR

case "$1" in

start)
	for N in 0 1 2 3 4 5 6 7; do
		# look for tsdev interface (Compaq ts protocol)
		if [ -d /sys/class/input/input${N}/ts0 ]; then
			unset TSLIB_TSDEVICE
			unset TSLIB_ENABLE
			# comment out the break to try tslib anyway
			break
		fi
		if [ -e /sys/class/input/input${N}/capabilities/abs ]; then
			# look for device with absolute x, y & pressure input
			ABS=`cat /sys/class/input/input${N}/capabilities/abs`
			if [ "$ABS" = "1000003" ]; then
				TSLIB_TSDEVICE=/dev/input/event$N
				export TSLIB_TSDEVICE
				TSLIB_ENABLE=1
				export TSLIB_ENABLE
				break
			fi
		fi
	done

	xinit ${XINITRC} -- /etc/X11/xinit/xserverrc &
	;;
	
stop)
	if [ -e /var/run/Xserver.pid ]; then
		kill $(cat /var/run/Xserver.pid)
	fi
	;;
*)
	echo "Usage: "$0" {start|stop}"
	;;
esac
