#!/bin/bash
GOSLEEP="$(which gosleep)"
if [ -z "${GOSLEEP}" ]; then
	if [ -x "/sbin/gosleep" ]; then
		GOSLEEP=/sbin/gosleep
	elif [ -x "/usr/local/sbin/gosleep" ]; then
		GOSLEEP=/usr/local/sbin/gosleep
	else
		echo "'gosleep' not found!"
		exit 1
	fi
fi

if [ -e /proc/sys/pm/suspend_catch ]
then

while true
do

    # note that the argument "Catch Sleep IRQ" is only present to help
    # identify this process from the output of 'ps'.

    if echo "Catch Sleep IRQ" > /proc/sys/pm/suspend_catch

    # When this echo command returns, this indicates that we 
    # have detected the sleep irq.

    then

	# any clean-up required before sleeping goes here IE:
	# killall -STOP my_program
	# sync

	# Source this script for increased speed
	logger -p user.info "Caught sleep IRQ - going to sleep"
	. ${GOSLEEP}

        # any clean-up required after sleeping goes here IE:
        # killall -CONT my_program

    fi
done
fi

