#!/bin/bash

PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin
export PATH

# Handle external sleep interrupt
# This script should run in the background, so don't
#  start the lower sleep scripts in background, too

# refuse to sleep on USB or NFS, since there are resume problems
if grep -q " / nfs" /proc/mounts || egrep -q '^/dev/sd.. / ' /proc/mounts; then
	exit 1
fi

case $(uname -r) in

    2.4*)
            /usr/local/sbin/catch_sleep.sh &
            ;;

    2.6*)
            if [ -f /proc/sys/pm/suspend_catch ]; then
                /usr/local/sbin/catch_sleep.sh &
            else
                /usr/local/sbin/rqonoff &
                if [ "$?" = 255 ] ; then
                    echo "No facility to sleep by external IRQ!"
                    exit 1
                fi
            fi
            ;;
esac

