# Function defs

yesorno () {
	if [ -z "$1" ]; then
		return 1
	fi
	case $1 in

		 [Yy][Ee][Ss]|[Yy])
			return 0
			;;
		*)
			return 1
			;;
	esac
	return 1
}

ask () {
	if ! [ -z "$1" ]; then
		read -p "$1 " yorn
		if yesorno "${yorn}" ; then
			return 0
		else
			return 1
		fi
	else
		return 1
	fi
}

errexit () {
	message=${1:-"Unknown error!"}
	echo "Fatal Error:"
	echo "${message}!"
	exit 1
}

jot () {
	# My cheap-n-dirty equiv for FreeBSD's `jot` command
	if [ -z "$2" ]; then
		errexit "Internal error in jot()"
	fi

	x=$1
	while [ $x -lt $2 ]; do
		echo $x
		x=$(($x + 1))
	done
}

link_target () {
	# Returns full path of a symlink's target
	if ! [ -L "$1" ]; then
		return $1
	fi
	listing=$(ls -l $1 | sed -e 's/.* -> //')
	if [ "${listing}" == "$(basename ${listing})" ]; then
		basearg=$(basename $1)
		pathto=$(echo $1 | sed -e "s/\/${basearg}//")
		echo "${pathto}/${listing}"
	else
		echo "${listing}"
	fi
}

